clear all;
clc;
%% Parametri di configurazione
format long g
P = 350;      % W
n = 350;      % rpm
V_ph = 13.86; % V
I_ph = 8.42;  % A
pp = 20;
m = 3;        % numero di fasi
f = 58.33;    % Hz
lm = 55e-3;     % m (altezza magnete)
PCB_th = 2e-3; % m spessore pcb 
airgap = 2e-3;   % m 
dist_mg = 6.5e-3;% m distanza tra magneti
Br = 1.30;    % T
lg = PCB_th + 2 * airgap; % m
mu_r = 1.05;

rho = 1.68e-8;    % @20°C Ohm*m
sigma = 58e6;     % @20°C S/m
mu_cu = 1.2566290e-6; % H/m permeabilità del rame
mu_0 = 4 * pi * 1e-7;

% 6 once
% h_tr = 0.208788e-3*2;
% 4 once
h_tr=(140e-6)*2;      % m altezza del conduttore in rame DOPPIO STRATO
% h_tr=140e-6;          % m altezza del conduttore in rame SINGOLO STRATO
Bg = Br * 2 * lm / (2 * lm  + mu_r * lg );

%% Parametri per ottimizzazione
R_ext = 104e-3;    % Raggio esterno in m
R_int = 15e-3;     % Raggio interno in m

% Limiti variabili di progettazione
% S_bounds = [0.1e-3, 0.3e-3]; % spessore delle tracce in m
L_bounds = [65e-3, 90e-3]; % lunghezza tracce in m

% Numero di spire
% il numero di spire calcolato come 20*3*x
%% Funzione obiettivo per gamultiobj (impostazioni "limiti")
fun = @(x) objFun_3D(x, I_ph, Bg, R_ext, mu_0, rho, mu_r, PCB_th, airgap, lm, pp, m, h_tr);

% Vincoli
lb = [L_bounds(1)];
ub = [L_bounds(2)];

% Numero di variabili ottimizzate
nvars = 1;
% Esecuzione dell'ottimizzazione multi-obiettivo
options = optimoptions('gamultiobj', 'Display', 'iter', 'PopulationSize', 100, 'ParetoFraction', 0.3);

[x_opt, fval, exitflag, output, population, scores] = gamultiobj(fun, nvars, [], [], [], [], lb, ub, [], options);
%%
function F = objFun_3D(x, I_ph, Bg, R_ext, mu_0, rho, mu_r, PCB_th, airgap, lm, pp, m, h_tr)
    % Variabili di progettazione
    
    L = x(1);        % lunghezza tracce (m)
    
    % Numero di spire
    %C = 2 * pi * (R_ext - R_int)
    C_int = 2 * pi * (R_ext-L); % Circonferenza interna per capire quante spire ci stanno in m
    C_ext = 2 * pi * R_ext;
    N_spire = pp*m*8;
    S = 0.1e-3;
    
    tr_w1 = C_int/N_spire - S;
    tr_w2 = C_ext/N_spire - S;
    trw=(tr_w2+tr_w1)/2;
    
    
    % Calcoli delle caratteristiche
    A_magn = pi * L^2; % Area della sezione magnetica in m^2
    % A_magn = pi * (R_ext - R_int)
    l_magn = (airgap + PCB_th + lm / mu_r); % Lunghezza magnetica effettiva in m
    
    % Area della traccia
    Area_track = h_tr * trw;
    
    % Resistenza della traccia
    R_traccia = rho * L / Area_track;
    
    % Resistenza di fase
    R_fase = R_traccia * N_spire/m; %numero di spire in serie per fase
    
    % Perdite Joule
    P_joule = R_fase * 6^2;
    
    % Induttanza di fase
    L_ind = mu_0 * (N_spire/m)^2 * A_magn / l_magn;
    %L_ind=2*mu_0*10^2*h_tr/tr_w*log(2+tr_w/h_tr);
    
    alpha=0.7683345/1.460;
    
    % Forza di Lorentz
    % (dalla formula originale tolgo m perchè N_spire dalla formula del paper è il numero di spire
    % per polo per fase)
    F_lorentz = alpha * Bg * N_spire * I_ph * L;
    % T=F_lorentz*L;
    
    % Funzione obiettivo (minimizzare Perdite Joule, massimizzare Forza di Lorentz, massimizzare Induttanza)
    F = [P_joule, 1/F_lorentz]; % Minimo P_joule, massimo F_lorentz e L_ind
end
% Funzione obiettivo 3D
fun_3D = @(x) objFun_3D(x, I_ph, Bg, R_ext, mu_0, rho, mu_r, PCB_th, airgap, lm, pp, m, h_tr);

% Esecuzione dell'ottimizzazione multi-obiettivo
[x_opt_3D, fval_3D] = gamultiobj(fun_3D, nvars, [], [], [], [], lb, ub, [], options);


% Visualizza il fronte di Pareto 3D
figure;
scatter(fval_3D(:, 1), 1/fval_3D(:, 2), 'filled');
xlabel('Joule Losses [W]');
ylabel('Lorentz force [N]');
%zlabel('Inductance [mH]');

title('Pareto Front 3D');
grid on;
set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
set(gcf, 'Color', 'w'); % Sfondo bianco della figura
box on; % Mantiene il bordo visibile

%% automatizziamo il processo
Pj=26.42;
L_indutt=0.00767574;
FL=171.133;
Nspire=60*8;
L= FL/(0.49886*Bg*Nspire*I_ph);
T=FL*L;
R_f=Pj/6^2;
Rtrace=R_f*3/Nspire;
A_track=rho*L/Rtrace;
trw_med=A_track/h_tr;
C_int=2*pi*(R_ext-L);
C_ext=2*pi*R_ext;
S=0.1e-3;
trw_ext=C_ext/Nspire - S;
trw_int=C_int/Nspire - S;
alpha=0.7683345/1.460;
s_mg = 25.3e-3;     % "base maggiore" del magnete in mm 
tau=2*pi*(R_ext-R_int)/pp;          % passo polare in m
alpha_i=s_mg/tau;              % il rapporto tra la larghezza del magnete e il passo polare
phi_mg=alpha*Bg*pi/pp *(R_ext^2-L^2)  
lambda=phi_mg*Nspire/3

EMF=Nspire/3*2*pi/sqrt(2)*phi_mg*f


%% VALUTAZIONI POSTUME PER N_SPIRE = 180, 300, 420, 480
% N_spire=[180, 300, 420, 480]; %per polo per fase
% P_j=[3.55126*2, 10.0695*2, 22.6025*2, 29.42*2];
% L=[1.06, 2.95838, 5.80179, 7.67] ;
% Fl=[63.7499, 106.243, 148.783, 171.133];
% figure;
% plot(N_spire, P_j, 'b-x', 'LineWidth', 1);
% hold on
% plot(N_spire, Fl, 'r-o', 'LineWidth',1);
% hold on
% plot(N_spire, L, 'g-*', 'LineWidth',1);
% xlabel('Number of traces');
% ylabel('F_L [N], P_J [W], L [mH]');
% grid on
% legend
% set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
% set(gcf, 'Color', 'w'); % Sfondo bianco della figura
% box on; % Mantiene il bordo visibile

%%
% I=linspace(0, 8, 100);
% R1=0.7338;
% P_j=R1*I.^2;
% R2= 0.5005;
% P_J2=R2*I.^2;
% % plot(I, P_j, 'r-o', 'LineWidth', 0.5)
% % hold on
% % plot(I, P_J2, 'b-x', 'LineWidth', 0.5)
% % xlabel('Current [A]');
% % ylabel('Joule Losses [W]');
% % grid on
% % legend
% % set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
% % set(gcf, 'Color', 'w'); % Sfondo bianco della figura
% % box on; % Mantiene il bordo visibile
% 
% %%
% alpha=0.7683345/1.460;
% F_lorentz = alpha * Bg * Nspire * L .* I;
% n=linspace(0,350,100);
% Telt=F_lorentz.*L;
% Pout=(T.*n*pi/30)-P_j;
% 
% % I1 =  0.1* (8/0.1) .^ linspace(0, 1, 100);
% % T1= alpha * Bg * Nspire * L^2 .* I1;
% figure 
% yyaxis left
% ylim([0 500])  % Imposta i limiti per la potenza
% 
% yyaxis right
% ylim([0 15])   % Imposta i limiti per la coppia
% 
% yyaxis right
% plot(n, T, '-.', 'Color', [1, 0.5, 0], 'LineWidth', 0.5)
% 
% xlabel('speed [rpm]');
% ylabel('Torque [Nm]');
% xlim([0 350])
% hold on
% yyaxis left
% plot(n, Pout, 'b-.', 'LineWidth',0.5);
% 
% ylabel('Power [W]');
% grid on
% legend('Power', 'Torque');
% set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
% set(gcf, 'Color', 'w'); % Sfondo bianco della figura
% box on; % Mantiene il bordo visibile
% 
% hold off; % Termina la sovrapposizione di nuovi elementi
% %%
% % Dati
% I = linspace(0, 8, 100); % Corrente da 0 a 8 A
% R1 = 0.7338; % Prima resistenza
% R2 = 0.5005; % Seconda resistenza
% 
% % Calcolo delle perdite Joule
% P_j1 = R1 * I.^2; % Perdite con R1
% P_j2 = R2 * I.^2; % Perdite con R2
% 
% % Creazione del grafico principale
% figure;
% plot(I, P_j1, 'r-o', 'LineWidth', 0.5, 'MarkerSize', 3, 'MarkerFaceColor', 'r');
% hold on;
% plot(I, P_j2, 'm-x', 'LineWidth', 0.5, 'MarkerSize', 3);
% 
% % Punto da evidenziare a I = 6 A
% I_highlight = 6;
% Pj1_highlight = R1 * I_highlight^2; % Potenza con R1 a 6A
% Pj2_highlight = R2 * I_highlight^2; % Potenza con R2 a 6A
% 
% % Evidenziare il punto su entrambe le curve
% plot(I_highlight, Pj1_highlight, 'bo', 'MarkerSize', 5, 'MarkerFaceColor', 'b', 'LineWidth', 1.5);
% plot(I_highlight, Pj2_highlight, 'bo', 'MarkerSize', 5, 'MarkerFaceColor', 'b', 'LineWidth', 1.5);
% 
% % Aggiungere una descrizione del punto evidenziato
% text(I_highlight, Pj1_highlight, '  \leftarrow Analysis Point', 'FontSize', 10, 'Color', 'b');
% text(I_highlight, Pj2_highlight, '  \leftarrow Analysis Point', 'FontSize', 10, 'Color', 'b');
% 
% % Etichette e formattazione
% xlabel('Current [A]');
% ylabel('Joule Losses [W]');
% grid on;
% legend('Joule Losses PCB - 4 once', 'Joule Losses PCB - 6 once', 'max current for the previous generator', 'Location', 'northwest');
% set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
% set(gcf, 'Color', 'w'); % Sfondo bianco della figura
% box on; % Mantiene il bordo visibile
% 
% hold off; % Termina la sovrapposizione di nuovi elementi
% %%
% Pe=1.65*PCB_th*pi*(R_ext^2-R_int^2)*Bg*h_tr^2*f^2/rho %2.14